/* - IRLearnListener -
 * Display learn data after a learn event
 *
 * Copyright 2011 Phidgets Inc.
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License.
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */
package listeners;

import com.phidgets.IRCodeInfo;
import com.phidgets.event.LearnEvent;
import com.phidgets.event.LearnListener;
import javax.swing.JButton;
import javax.swing.JTextField;
import javax.swing.JFrame;

import java.util.Enumeration;
import java.util.Hashtable;

public class IRLearnListener implements LearnListener {

    private JFrame appFrame;
    private JTextField learnIRCodeTxt;
    private JTextField learnBitLengthTxt;
    private JTextField learnEncodingTxt;
    private JTextField learnLengthTxt;
    private JTextField learnGapTxt;
    private JTextField learnTrailTxt;
    private JTextField learnZeroTxt;
    private JTextField learnOneTxt;
    private JTextField learnHeaderTxt;
    private JTextField learnRepeatTxt;
    private JTextField learnToggleMaskTxt;
    private JButton retransmitBtn;
    private int repeatCount;
    private Hashtable encodingTypeHashTable;
    private Hashtable lengthTypeHashTable;

    public IRLearnListener(JFrame appFrame, JTextField learnIRCodeTxt, JTextField learnBitLengthTxt, JTextField learnEncodingTxt, JTextField learnLengthTxt,
            JTextField learnGapTxt, JTextField learnTrailTxt, JTextField learnZeroTxt, JTextField learnOneTxt, JTextField learnHeaderTxt,
            JTextField learnRepeatTxt, JTextField learnToggleMaskTxt, JButton retransmitBtn) {

        this.appFrame = appFrame;
        this.learnIRCodeTxt = learnIRCodeTxt;
        this.learnBitLengthTxt = learnBitLengthTxt;
        this.learnEncodingTxt = learnEncodingTxt;
        this.learnLengthTxt = learnLengthTxt;
        this.learnGapTxt = learnGapTxt;
        this.learnTrailTxt = learnTrailTxt;
        this.learnZeroTxt = learnZeroTxt;
        this.learnOneTxt = learnOneTxt;
        this.learnHeaderTxt = learnHeaderTxt;
        this.learnRepeatTxt = learnRepeatTxt;
        this.learnToggleMaskTxt = learnToggleMaskTxt;
        this.retransmitBtn = retransmitBtn;

        encodingTypeHashTable = new Hashtable();
        encodingTypeHashTable.put("Bi-Phase", IRCodeInfo.ENCODING_BIPHASE);
        encodingTypeHashTable.put("Pulse", IRCodeInfo.ENCODING_PULSE);
        encodingTypeHashTable.put("RC5", IRCodeInfo.ENCODING_RC5);
        encodingTypeHashTable.put("RC6", IRCodeInfo.ENCODING_RC6);
        encodingTypeHashTable.put("Space", IRCodeInfo.ENCODING_SPACE);
        encodingTypeHashTable.put("Unknown", IRCodeInfo.ENCODING_UNKNOWN);

        lengthTypeHashTable = new Hashtable();
        lengthTypeHashTable.put("Constant", IRCodeInfo.LENGTH_CONSTANT);
        lengthTypeHashTable.put("Unknown", IRCodeInfo.LENGTH_UNKNOWN);
        lengthTypeHashTable.put("Variable", IRCodeInfo.LENGTH_VARIABLE);
    }

    public void learn(LearnEvent le) {
        int i = 0;
        learnIRCodeTxt.setText("0x" + le.getValue().getCode().toString());
    
        learnBitLengthTxt.setText(Integer.toString(le.getValue().getCodeInfo().getBitCount()));

        String foundEncoding = findKey(encodingTypeHashTable, le.getValue().getCodeInfo().getEncoding());
        learnEncodingTxt.setText(foundEncoding);

        String foundLength = findKey(lengthTypeHashTable, le.getValue().getCodeInfo().getLength());
        learnLengthTxt.setText(foundLength + " Length");

        learnGapTxt.setText(Integer.toString(le.getValue().getCodeInfo().getGap()));

        if (le.getValue().getCodeInfo().getTrail() != 0) {
            learnTrailTxt.setText((Integer.toString(le.getValue().getCodeInfo().getTrail())));
        } else {
            learnTrailTxt.setText("None");
        }

        learnZeroTxt.setText(Integer.toString(le.getValue().getCodeInfo().getZero()[0]) + ", "
                + Integer.toString(le.getValue().getCodeInfo().getZero()[1]));

        learnOneTxt.setText(Integer.toString(le.getValue().getCodeInfo().getOne()[0]) + ", "
                + Integer.toString(le.getValue().getCodeInfo().getOne()[1]));

        if (le.getValue().getCodeInfo().getHeader() != null) {
            String headerString = "";
            for (int header : le.getValue().getCodeInfo().getHeader()) {
                i++;
                if (i != le.getValue().getCodeInfo().getHeader().length) {
                    headerString += header + ", ";
                } else {
                    headerString += header;
                }
            }
            i = 0;
            learnHeaderTxt.setText(headerString);
        } else {
            learnHeaderTxt.setText("No header");
        }

        if (le.getValue().getCodeInfo().getRepeat() != null) {
            String repeatString = "";
            for (int repeat : le.getValue().getCodeInfo().getRepeat()) {
                i++;
                if (i != le.getValue().getCodeInfo().getRepeat().length) {
                    repeatString += repeat + ", ";
                } else {
                    repeatString += repeat;
                }
            }
            learnRepeatTxt.setText(repeatString);
        }
        else{
            learnRepeatTxt.setText("No Repeat Code");
        }


        if (le.getValue().getCodeInfo().getToggleMask() != null) {
            learnToggleMaskTxt.setText("0x" + le.getValue().getCodeInfo().getToggleMask().toString());
        } else {
            learnToggleMaskTxt.setText("No Toggle Mask");
        }

        retransmitBtn.setEnabled(true);


    }

    private String findKey(Hashtable hashTable, int element){
        Enumeration eKeys = hashTable.keys();
        while (eKeys.hasMoreElements()) {
            Object currKey = eKeys.nextElement();
            if (((Integer) hashTable.get(currKey)).intValue() == element)
                return(currKey.toString());
            }
        return("Unknown");
    }
}
